% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oat.R
\name{show_oat_results}
\alias{show_oat_results}
\title{Visualize OFAT Sensitivity Analysis Outcomes}
\usage{
show_oat_results(node_name, results, tree)
}
\arguments{
\item{node_name}{\code{character} specifying the name of the node intended
for visualization.}

\item{results}{Matrix of evaluation results, typically derived from
\code{ofat_sensitivity_analysis}.}

\item{tree}{A \code{Tree} object that was employed in the OFAT analysis.}
}
\value{
This function does not return a value; instead, it exhibits a plot.
}
\description{
Renders a visualization representing the One-Factor-At-A-Time (OFAT)
sensitivity analysis results.
}
\examples{
tree <- dexisensitivity::masc2
optionOAT <- create_options(tree, 1)
results <- oat(tree, optionOAT)
show_oat_results("Dimension economique", results, tree)

}
