% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{schoolfieldHigh_81}
\alias{schoolfieldHigh_81}
\title{Schoolfield et al. equation of development rate as a function of temperature for
intermediate to high temperatures only.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1016/0022-5193(81)90246-0}
}
\usage{
schoolfieldHigh_81
}
\description{
Schoolfield, R., Sharpe, P. & Magnuson, C. (1981) Non-linear regression of biological
temperature-dependent rate models based on absolute reaction-rate theory.
Journal of theoretical biology, 88, 719-731.
Wagner, T.L., Wu, H.I., Sharpe, P.S.H., Schoolfield, R.M., Coulson, R.N. (1984) Modeling
insect development rates: a literature review and application of a biophysical model.
Annals of the Entomological Society of America 77(2): 208-20.
}
\details{
Equation:
\deqn{rT = \frac{p25 * \frac{T + 273.16}{298} * e^{\frac{aa}{1.987} * (\frac{1}{298} - \frac{1}{T + 273.16})}}{1 + e^{\frac{dd}{1.987} * (\frac{1}{ee} - \frac{1}{T + 273.16})}}}{%
      rT = (p25 * (T + 273.16)/298 * exp(aa/1.987 * (1/298 - 1/(T + 273.16)))) / (1 + exp(dd/1.987 * (1/ee - 1/(T + 273.16))))}

where rT is the development rate, T the temperature, p25 the development
rate at 25 degrees Celcius assuming no enzyme inactivation, aa the enthalpy of
activation of the reaction that is catalyzed by the enzyme, bb the change in
enthalpy associated with low temperature inactivation of the enzyme, cc the
the temperature at which the enzyme is 1/2 active and 1/2 low temperature inactive,
dd the cange in enthalpy associated with high temperature inactivation of the enzyme,
and ee the temperature at which the enzyme is 1/2 active and 1/2 high temperature
inactive.
}
\keyword{datasets}
