% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_nls.R
\name{devRateModel}
\alias{devRateModel}
\title{Compute non-linear regression}
\usage{
devRateModel(eq, temp, devRate, startValues, ...)
}
\arguments{
\item{eq}{The name of the equation.}

\item{temp}{The temperature.}

\item{devRate}{The developmental rate \code{(days)^-1}}

\item{startValues}{Starting values for the regression.}

\item{...}{Additional arguments for the \code{nls} function.}
}
\value{
An object of class \code{nls} (except for Stinner et al. 1974 and
  Lamb 1992 where the function returns a list of two objects of class \code{nls}).
}
\description{
Determine the nonlinear least-squares estimates of the parameters of a nonlinear model, on
  the basis of the \code{nls} function from package \code{stats}.
}
\details{
\code{startValues} for equations by Stinner et al. 1974 and Lamb 1992 are composed of
  two equations: one for the temperatures below the optimal temperature and another for the
  tamperatures above the optimal temperature. For these equations, \code{startValues} should
  be a list of two lists, where the second element only contain starting estimates not
  specified in the first element, e.g., for Stinner et al.:
  \code{startValues <- list(list(C = 0.05, k1 = 5, k2 = -0.3), list(Topt = 30))},
  and for Lamb 1992:
  \code{startValues <- list(list(Rm = 0.05, Tmax = 35, To = 15), list(T1 = 4))}
}
\examples{
## Example with a linear model (no starting estimates)
myT <- 5:15
myDev <- -0.05 + rnorm(n = length(myT), mean = myT, sd = 1) * 0.01
myNLS <- devRateModel(eq = campbell_74, temp = myT, devRate = myDev)
## Example with a non-linear model (starting estimates)
myT <- seq(from = 0, to = 50, by = 10)
myDev <- c(0.001, 0.008, 0.02, 0.03, 0.018, 0.004)
myNLS <- devRateModel(eq = stinner_74, temp = myT, devRate = myDev,
  startValues = list(list(C = 0.05, k1 = 5, k2 = -0.3), list(Topt = 30)))
}
