% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{chi2testtable}
\alias{chi2testtable}
\title{(Contingency) Tables for Chi-square Tests}
\usage{
chi2testtable(x, alpha, cf = FALSE)
}
\arguments{
\item{x}{vector with normalized data between 0 and 1.}

\item{alpha}{significance level.}

\item{cf}{flag, if \code{TRUE}, bin counts for a multi-variate contingency table are applied (Bagnato et al., 2012). Otherwise rules for univariate tables are used (Cochran, 1952; Mann and Wald, 1942).}
}
\value{
Object with observed counts \code{co} of data \code{x} inside bins defined by edges \code{be}.
}
\description{
(Contingency) tables for Pearson's Chi-square goodness-of-fit and independence tests.
}
\references{
Cochran, W.G., The Chi Square Test of Goodness of Fit. The Annals of Mathematical Statistics, 1952. 23(3): p. 315-345.

Mann, H.B. and A. Wald, On the Choice of the Number of Class Intervals in the Application of the Chi Square Test. The Annals of Mathematical Statistics, 1942. 13(3): p. 306-317.

Bagnato, L., A. Punzo, and O. Nicolis, The autodependogram: a graphical device to investigate serial dependences. Journal of Time Series Analysis, 2012. 33(2): p. 233-254.
}
