% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_to_telegram.R
\name{send_to_telegram}
\alias{send_to_telegram}
\alias{send_to_telegram.character}
\alias{send_to_telegram.gg}
\title{Send something to telegram}
\usage{
send_to_telegram(x, ..., chat_id, bot)

\method{send_to_telegram}{character}(
  x,
  type = c("message", "photo", "document", "audio", "animation", "video", "voice",
    "sticker", "location", "videonote"),
  ...,
  chat_id = getOption("depigner.chat_id"),
  bot = getOption("depigner.bot")
)

\method{send_to_telegram}{gg}(
  x,
  fileext = c("png", "pdf", "jpeg", "tiff", "bmp"),
  ...,
  chat_id = getOption("depigner.chat_id"),
  bot = getOption("depigner.bot")
)
}
\arguments{
\item{x}{object to send (often a character string)}

\item{...}{further argument to pass to the sending methods (see
\code{\link[telegram.bot]{Bot}} for specifications.)}

\item{chat_id}{chat_id in which send the object. By default all the
methods consider the chat_id defined in the previous run of
\code{\link{start_bot_for_chat}}.}

\item{bot}{(\code{\link[telegram.bot]{Bot}}) the bot object.
By default all the methods consider the bot created by a
previous run of \code{\link{start_bot_for_chat}}.}

\item{type}{(chr, default = "message") the type of text represent
\code{x}. I.e., if not "message", it is normally considered as
a path to the corresponding object. For further clarification
see \code{\link[telegram.bot]{Bot}} help page.}

\item{fileext}{(chr, default "png") one of the possible file format
supported: "png", "pdf", "jpeg", "tiff" or "bmp"}
}
\value{
invisible the object x.
}
\description{
This is a generic function to send some object to telegram.
}
\details{
By default it use the bot and chat_id configured by
\code{\link{start_bot_for_chat}}. The user can pass a custom bot or
chat_id providing them to the corresponding argument.
}
\examples{
\dontrun{
  library(depigner)
  library(ggplot2)

  start_bot_for_chat()
  send_to_telegram("hello world")

  gg <- ggplot(mtcars, aes(x = mpg, y = hp, colour = cyl)) +
  geom_point()

  send_to_telegram(
    "following an `mtcars` coloured plot",
    parse_mode = "Markdown"
  )
  send_to_telegram(gg)
}
}
