% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_cce.R
\name{prep_cce}
\alias{prep_cce}
\title{Pre-Process Chronology of Constitutional Events (CCE) Data}
\usage{
prep_cce(
  cce,
  cow_fix = TRUE,
  evnttype_fix = TRUE,
  years = c(min(cce$year), max(cce$year))
)
}
\arguments{
\item{cce}{A \code{data.frame} or \code{data.table} of CCE data.}

\item{cow_fix}{Logical to hardcode changes to CCE cowcode values for
Yugoslavia/Serbia, present day Germany, and present day Yemen to match
official CoW designations.}

\item{evnttype_fix}{Logical to hardcode (presumed) typos in \code{evnttype}
coding.}

\item{years}{Numeric vector of length 2 to subset data with.}
}
\value{
A \code{data.frame} of pre-processed CCE data.
}
\description{
Pre-Process Chronology of Constitutional Events (CCE) Data
}
\examples{

cce<-demcon::get_cce(del_file=TRUE, write_out = FALSE)

cce<-demcon::prep_cce(cce, cow_fix = TRUE, evnttype_fix = TRUE)

}
\seealso{
\href{https://comparativeconstitutionsproject.org/download-data/}{The Comparative Constitutions Project}
}
