/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Connection;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.Peak;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

public class IsotopicSetGraphToDotGraph {
    private static final String LINESEP = "\n";
    private static final String COLOR = "[color=\"";
    private static final String LABEL = "\",label=\"";
    private static final String WEIGHT = "\",weight=\"";

    public static String toDOTGraph(DefaultDirectedWeightedGraph<IsotopicCluster, Connection> iClusterGraph) {
        StringBuilder stringBuilder = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        stringBuilder.append("digraph {").append(lineSep);
        stringBuilder.append("rankdir=LR;").append(lineSep);
        stringBuilder.append("node [shape=box];").append(lineSep);
        for (Connection connection : iClusterGraph.edgeSet()) {
            if (((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).isNotNull() && ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) {
                IsotopicSetGraphToDotGraph.appendOtherVertex(stringBuilder, connection, iClusterGraph);
                continue;
            }
            if (((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).isNull() && ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) {
                IsotopicSetGraphToDotGraph.appendStartVertex(stringBuilder, connection, iClusterGraph);
                continue;
            }
            if (!((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).isNull() || !((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).isNotNull()) continue;
            IsotopicSetGraphToDotGraph.appendEndVertex(stringBuilder, connection, iClusterGraph);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static void appendOtherVertex(StringBuilder stringBuilder, Connection connection, DefaultDirectedWeightedGraph<IsotopicCluster, Connection> iClusterGraph) {
        stringBuilder.append("\"(" + ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getClusterID() + ") [ ");
        for (Peak peak : ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getIsotopicCluster()) {
            stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
        }
        stringBuilder.append("] z:" + ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getCharge() + "\" -> \"(" + ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getClusterID() + ") [ ");
        for (Peak peak : ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
            stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
        }
        stringBuilder.append("] z:" + ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getCharge() + "\"").append(COLOR + connection.getColor() + LABEL + (double)Math.round(iClusterGraph.getEdgeWeight((Object)connection) * 10000.0) / 10000.0 + WEIGHT + iClusterGraph.getEdgeWeight((Object)connection) + "\"];").append(LINESEP);
    }

    private static void appendStartVertex(StringBuilder stringBuilder, Connection connection, DefaultDirectedWeightedGraph<IsotopicCluster, Connection> iClusterGraph) {
        stringBuilder.append(((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getStatus());
        stringBuilder.append(" -> \"(" + ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getClusterID() + ") [ ");
        for (Peak peak : ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
            stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
        }
        stringBuilder.append("] z:" + ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getCharge() + "\"").append(COLOR + connection.getColor() + LABEL + (double)Math.round(iClusterGraph.getEdgeWeight((Object)connection) * 10000.0) / 10000.0 + WEIGHT + iClusterGraph.getEdgeWeight((Object)connection) + "\"];").append(LINESEP);
    }

    private static void appendEndVertex(StringBuilder stringBuilder, Connection connection, DefaultDirectedWeightedGraph<IsotopicCluster, Connection> iClusterGraph) {
        stringBuilder.append("\"(" + ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getClusterID() + ") [ ");
        for (Peak peak : ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getIsotopicCluster()) {
            stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
        }
        stringBuilder.append("] z:" + ((IsotopicCluster)iClusterGraph.getEdgeSource((Object)connection)).getCharge() + "\" -> " + ((IsotopicCluster)iClusterGraph.getEdgeTarget((Object)connection)).getStatus()).append(COLOR + connection.getColor() + LABEL + (double)Math.round(iClusterGraph.getEdgeWeight((Object)connection) * 10000.0) / 10000.0 + WEIGHT + iClusterGraph.getEdgeWeight((Object)connection) + "\"];").append(LINESEP);
    }

    private IsotopicSetGraphToDotGraph() {
        throw new IllegalStateException("Dot Graph class");
    }
}

