/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.IsotopicSetGraph;
import ch.fgcz.proteomics.fbdm.IsotopicSetGraphToDotGraph;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class IsotopicSet {
    private final PeakList peakList;
    private List<IsotopicCluster> iSet = null;
    private List<IsotopicCluster> bestPath = null;
    private List<Peak> peaksInSet = null;
    private String dot = null;
    private int setId;

    public IsotopicSet(PeakList peakList, List<Peak> peaksInSet, int setId, Configuration config) {
        this.peakList = peakList;
        IsotopicSet.rangeCheck(peaksInSet, config);
        this.peaksInSet = peaksInSet;
        this.setId = setId;
        List<IsotopicCluster> tempIsotopicSet = this.collectClusters(config, peaksInSet);
        for (IsotopicCluster isotopicCluster : tempIsotopicSet) {
            isotopicCluster.scoreCluster(config);
        }
        this.iSet = tempIsotopicSet;
        this.setBestPath(peakList, tempIsotopicSet, config);
    }

    public static PeakList checkForCorrectRangeOfPeaks(PeakList peakList, Configuration config) {
        if (peakList.isSortedByMass()) {
            for (int i = 0; i < peakList.size() - 1; ++i) {
                double distance = peakList.get(i + 1).getMz() - peakList.get(i).getMz();
                boolean b = false;
                for (int charge = 1; charge <= 3; ++charge) {
                    if (!MathUtils.fuzzyEqual(config.getIsotopicPeakDistance() / (double)charge, Math.abs(distance), config.getDelta())) continue;
                    b = true;
                }
                if (b) continue;
                return null;
            }
            return peakList;
        }
        throw new IllegalArgumentException("Not Sorted");
    }

    public List<Peak> getPeaksInSet() {
        return this.peaksInSet;
    }

    public int getSetId() {
        return this.setId;
    }

    public void setSetId(int setId) {
        this.setId = setId;
    }

    public List<IsotopicCluster> getIsotopicSet() {
        return this.iSet;
    }

    public String getDot() {
        return this.dot;
    }

    public List<IsotopicCluster> getBestPath() {
        ArrayList<IsotopicCluster> bestClusters = new ArrayList<IsotopicCluster>();
        for (IsotopicCluster isotopicCluster : this.bestPath) {
            if (!isotopicCluster.isNotNull()) continue;
            bestClusters.add(isotopicCluster);
        }
        return bestClusters;
    }

    protected static List<IsotopicCluster> removeOverlappingPeaksInClusters(List<IsotopicCluster> isotopicClusters) {
        for (IsotopicCluster isotopicCluster1 : isotopicClusters) {
            for (IsotopicCluster isotopicCluster2 : isotopicClusters) {
                if (isotopicCluster1.equals(isotopicCluster2) || !isotopicCluster1.hasSamePeaks(isotopicCluster2)) continue;
                isotopicCluster1.manipulateWhenHasSamePeaks(isotopicCluster2);
            }
        }
        return isotopicClusters;
    }

    protected static List<IsotopicCluster> removeDoubleClusterLeaveTripleCluster(List<IsotopicCluster> isotopicClusters) {
        ArrayList<IsotopicCluster> isotopicClusters2 = new ArrayList<IsotopicCluster>();
        for (IsotopicCluster cluster1 : isotopicClusters) {
            for (IsotopicCluster cluster2 : isotopicClusters) {
                IsotopicSet.innerIfStatementsOfRemoveDoubleCluster(isotopicClusters2, cluster1, cluster2);
            }
        }
        isotopicClusters.removeAll(IsotopicSet.removeMultipleIsotopicCluster(isotopicClusters2));
        return isotopicClusters;
    }

    private List<IsotopicCluster> collectClusters(Configuration config, List<Peak> peaksInSet) {
        List<IsotopicCluster> isotopicClusters = new ArrayList<IsotopicCluster>();
        for (int charge = 3; 0 < charge; --charge) {
            this.collectClusterForEachCharge(isotopicClusters, peaksInSet, charge, config);
        }
        isotopicClusters = IsotopicSet.removeMultipleIsotopicCluster(isotopicClusters);
        IsotopicSet.sortIsotopicSet(isotopicClusters);
        this.setPositions(isotopicClusters);
        return isotopicClusters;
    }

    private List<IsotopicCluster> setPositions(List<IsotopicCluster> isotopicClusters) {
        int clusterId = 0;
        for (IsotopicCluster isotopicCluster : isotopicClusters) {
            isotopicCluster.setClusterID(clusterId);
            ++clusterId;
        }
        for (IsotopicCluster isotopicCluster : isotopicClusters) {
            if (!isotopicCluster.isNotNull()) continue;
            int position = 1;
            for (Peak peak : isotopicCluster.getIsotopicCluster()) {
                peak.setIsotopicSetID(this.setId);
                peak.setIsotopicClusterID(isotopicCluster.getClusterID());
                peak.setIsotope(position);
                ++position;
            }
        }
        return isotopicClusters;
    }

    private void setBestPath(PeakList peaklist, List<IsotopicCluster> isotopicClusters, Configuration config) {
        ArrayList<IsotopicCluster> isotopicClustersForBestPath = new ArrayList<IsotopicCluster>(isotopicClusters);
        IsotopicSetGraph isotopicSetGraphForBestPath = new IsotopicSetGraph(IsotopicSet.removeDoubleClusterLeaveTripleCluster(isotopicClustersForBestPath), config);
        this.bestPath = isotopicSetGraphForBestPath.bestPath(isotopicSetGraphForBestPath.getStart(), isotopicSetGraphForBestPath.getEnd()).getVertexList();
        ArrayList<IsotopicCluster> isotopicClustersForDot = new ArrayList<IsotopicCluster>(isotopicClusters);
        IsotopicSetGraph isotopicSetGraph = new IsotopicSetGraph(isotopicClustersForDot, config);
        this.dot = IsotopicSetGraphToDotGraph.toDOTGraph(isotopicSetGraph.getIsotopicClusterGraph());
    }

    private List<IsotopicCluster> collectClusterForEachCharge(List<IsotopicCluster> isotopicClusters, List<Peak> isotopicSet, int charge, Configuration config) {
        for (Peak a : isotopicSet) {
            for (Peak b : isotopicSet) {
                double distanceab = b.getMz() - a.getMz();
                for (Peak c : isotopicSet) {
                    List<Peak> ic = IsotopicSet.innerIfStatementsOfCollectCluster(a, b, c, charge, config, distanceab);
                    if (ic.size() != 2 && ic.size() != 3) continue;
                    IsotopicCluster cluster = new IsotopicCluster(ic, charge, this.peakList, config.getIsotopicPeakDistance(), config.getDelta());
                    isotopicClusters.add(cluster);
                }
            }
        }
        return isotopicClusters;
    }

    private static void innerIfStatementsOfRemoveDoubleCluster(List<IsotopicCluster> isotopicClusters, IsotopicCluster cluster1, IsotopicCluster cluster2) {
        if (cluster1.size() == 3 && cluster2.size() == 2 && cluster1.getPeak(1).equalsPeak(cluster2.getPeak(0)) && cluster1.getPeak(2).equalsPeak(cluster2.getPeak(1))) {
            isotopicClusters.add(cluster2);
        } else if (cluster1.size() == 2 && cluster2.size() == 3 && cluster1.getPeak(0).equalsPeak(cluster2.getPeak(0)) && cluster1.getPeak(1).equalsPeak(cluster2.getPeak(1))) {
            isotopicClusters.add(cluster1);
        }
    }

    private static List<Peak> innerIfStatementsOfCollectCluster(Peak a, Peak b, Peak c, int charge, Configuration config, double distanceab) {
        ArrayList<Peak> ic = new ArrayList<Peak>();
        double distanceac = c.getMz() - a.getMz();
        double distancebc = c.getMz() - b.getMz();
        if (config.getIsotopicPeakDistance() / (double)charge - config.getDelta() < distanceab && distanceab < config.getIsotopicPeakDistance() / (double)charge + config.getDelta()) {
            a.setCharge(charge);
            b.setCharge(charge);
            ic.add(a);
            ic.add(b);
        }
        if (config.getIsotopicPeakDistance() / (double)charge - config.getDelta() < distancebc && distancebc < config.getIsotopicPeakDistance() / (double)charge + config.getDelta() && (config.getIsotopicPeakDistance() / (double)charge - config.getDelta()) * 2.0 < distanceac && distanceac < (config.getIsotopicPeakDistance() / (double)charge + config.getDelta()) * 2.0) {
            c.setCharge(charge);
            ic.add(c);
        }
        return ic;
    }

    private static List<IsotopicCluster> removeMultipleIsotopicCluster(List<IsotopicCluster> isotopicClusters) {
        ArrayList<IsotopicCluster> result = new ArrayList<IsotopicCluster>();
        HashSet<List<Peak>> set = new HashSet<List<Peak>>();
        for (IsotopicCluster cluster : isotopicClusters) {
            if (!set.add(cluster.getIsotopicCluster())) continue;
            result.add(cluster);
        }
        return result;
    }

    private static void rangeCheck(List<Peak> peaks, Configuration config) {
        for (int i = 0; i < peaks.size() - 1; ++i) {
            double distance = peaks.get(i + 1).getMz() - peaks.get(i).getMz();
            boolean b = false;
            for (int charge = 1; charge <= 3; ++charge) {
                if (!(config.getIsotopicPeakDistance() / (double)charge - config.getDelta() < Math.abs(distance)) || !(Math.abs(distance) < config.getIsotopicPeakDistance() / (double)charge + config.getDelta())) continue;
                b = true;
            }
            if (b) continue;
            throw new IllegalArgumentException("Wrong distance at IsotopicSet creation! (" + distance + ")");
        }
    }

    private static List<IsotopicCluster> sortIsotopicSet(List<IsotopicCluster> isotopicClusters) {
        Collections.sort(isotopicClusters, new Comparator<IsotopicCluster>(){

            @Override
            public int compare(IsotopicCluster cluster1, IsotopicCluster cluster2) {
                int result = Double.compare(cluster1.getPeak(0).getMz(), cluster2.getPeak(0).getMz());
                if (result == 0 && (result = Double.compare(cluster1.getPeak(1).getMz(), cluster2.getPeak(1).getMz())) == 0 && cluster1.size() == 3 && cluster2.size() == 3) {
                    result = Double.compare(cluster1.getPeak(2).getMz(), cluster2.getPeak(2).getMz());
                    return result;
                }
                return result;
            }
        });
        return isotopicClusters;
    }
}

