% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.deeptrafo}
\alias{plot.deeptrafo}
\alias{coef.deeptrafo}
\alias{predict.deeptrafo}
\alias{fitted.deeptrafo}
\alias{logLik.deeptrafo}
\alias{simulate.deeptrafo}
\alias{print.deeptrafo}
\alias{summary.deeptrafo}
\title{Generic methods for neural network transformation models}
\usage{
\method{plot}{deeptrafo}(
  x,
  which = NULL,
  type = c("smooth", "trafo", "pdf", "cdf"),
  newdata = NULL,
  which_param = c("shifting", "interacting"),
  only_data = FALSE,
  K = 40,
  q = NULL,
  ...
)

\method{coef}{deeptrafo}(
  object,
  which_param = c("shifting", "interacting", "autoregressive"),
  type = NULL,
  ...
)

\method{predict}{deeptrafo}(
  object,
  newdata = NULL,
  type = c("trafo", "pdf", "cdf", "interaction", "shift", "terms"),
  batch_size = NULL,
  K = 100,
  q = NULL,
  ...
)

\method{fitted}{deeptrafo}(object, newdata = NULL, batch_size = NULL, convert_fun = as.matrix, ...)

\method{logLik}{deeptrafo}(
  object,
  newdata = NULL,
  convert_fun = function(x, ...) -sum(x, ...),
  ...
)

\method{simulate}{deeptrafo}(object, nsim = 1, seed = NULL, newdata = NULL, ...)

\method{print}{deeptrafo}(x, print_model = FALSE, print_coefs = TRUE, with_baseline = FALSE, ...)

\method{summary}{deeptrafo}(object, ...)
}
\arguments{
\item{x}{Object of class \code{"deeptrafo"}.}

\item{which}{Which effect to plot, default selects all smooth effects in the
shift term.}

\item{type}{Either NULL (all types of coefficients are returned),
"linear" for linear coefficients or "smooth" for coefficients of;
Note that \code{type} is currently not used for \code{"interacting"}.}

\item{newdata}{Named \code{list} or \code{data.frame}; optional new data.}

\item{which_param}{Character; either \code{"shifting"}, \code{"interacting"},
or \code{"autoregressive"} (only for autoregressive transformation models).}

\item{only_data}{Logical, if \code{TRUE}, only the data for plotting is returned.}

\item{K}{Integer; grid length for the response to evaluate predictions at,
if \code{newdata} does not contain the response.}

\item{q}{Numeric or factor; user-supplied grid of response values to evaluate
the predictions. Defaults to \code{NULL}. If overwritten, \code{K} is
ignored.}

\item{...}{Further arguments supplied to \code{print.deeptrafo}}

\item{object}{Object of class \code{"deeptrafo"}.}

\item{batch_size}{Integer; optional, useful if data is too large.}

\item{convert_fun}{Function; applied to the log-likelihood values of all
observations.}

\item{nsim}{Integer; number of simulations; defaults to 1.}

\item{seed}{Seed for generating samples; defaults to \code{NULL}.}

\item{print_model}{Logical; print keras model.}

\item{print_coefs}{Logical; print coefficients.}

\item{with_baseline}{Logical; print baseline coefs.}
}
\value{
Returns vector or matrix of predictions, depending on the supplied
    \code{type}.

Returns matrix of fitted values.
}
\description{
Generic methods for neural network transformation models
}
\details{
If no new data is supplied, predictions are computed on the training
    data (i.e. in-sample). If new data is supplied without a response,
    predictions are evaluated on a grid of length \code{K}.
}
