% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod-button-indicator.R
\name{with_busy_indicator_ui}
\alias{with_busy_indicator_ui}
\alias{with_busy_indicator_server}
\title{Show busy indicator}
\usage{
with_busy_indicator_ui(button)

with_busy_indicator_server(button_id, expr)
}
\arguments{
\item{button}{A Shiny actionButton}

\item{button_id}{id of shiny actionButton}

\item{expr}{the code to run when the button is clicked}
}
\value{
Shiny UI and server logic
}
\description{
These functions add button feedback features including: disabling the button
while processing requested function, showing a spinning wheel while
processing requested function, displaying a green checkmark showing success
upon completion, or displaying an error message if the function requested
failed. They require the development version of
\href{https://github.com/daattali/shinyjs}{shinyjs} (>= 1.0.1.9006). With earlier
versions, the buttons will succeed but visual indicator feedback will not
appear.
}
\details{
Wrap the button in this function to attach visual features.

Redistributed with minor modifications under MIT License from:
https://github.com/daattali/advanced-shiny/blob/de590d593a0871848a3a31afd82584637decc972/busy-indicator/helpers.R

Hint for making this work with modules by mmoisse in PR#11: https://github.com/daattali/advanced-shiny/pull/11

Copyright 2019 Dean Attali

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
}
\examples{
library("shiny")

server <- function(input, output) {
  observeEvent(input$action, {
    with_busy_indicator_server("action", {
      Sys.sleep(1)
      output$value <- renderPrint("Success!")
    })
  })
}

ui <- fluidPage(
  includeCSS(
   system.file("app/www/custom.css", package = "dccvalidator")
  ),
  with_busy_indicator_ui(actionButton("action", label = "Action")),
  fluidRow(column(2, textOutput("value")))
)

\dontrun{
shinyApp(ui, server)
}
}
\author{
Dean Attali \href{mailto:dean@attalitech.com}{dean@attalitech.com}
}
