% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db-misc}
\alias{db_connection_describe}
\alias{sql_join_suffix}
\alias{db_sql_render}
\alias{dbplyr_edition}
\title{Miscellaneous database generics}
\usage{
db_connection_describe(con)

sql_join_suffix(con, ...)

db_sql_render(con, sql, ...)

dbplyr_edition(con)
}
\description{
\itemize{
\item \code{db_connection_describe()} provides a short string describing the
database connection, helping users tell which database a table comes
from. It should be a single line, and ideally less than 60 characters wide.
}
}
\details{
\itemize{
\item \code{dbplyr_edition()} declares which version of the dbplyr API you want.
See below for more details.
}
}
\section{dplyr 2.0.0}{

dplyr 2.0.0 renamed a number of generics so that they could be cleanly moved
from dplyr to dbplyr. If you have an existing backend, you'll need to rename
the following methods.
\itemize{
\item \code{dplyr::db_desc()} -> \code{dbplyr::db_connection_describe()} (also note that
the argument named changed from \code{x} to \code{con}).
}
}

\seealso{
Other generic: 
\code{\link{db-sql}},
\code{\link{db_copy_to}()},
\code{\link{sql_escape_logical}()}
}
\concept{generic}
\keyword{internal}
