% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_clean.R
\name{cleanwq}
\alias{cleanwq}
\title{Clean raw water quality DBHYDRO data retrievals}
\usage{
cleanwq(dt, mdl_handling = "raw")
}
\arguments{
\item{dt}{data.frame output of getwq}

\item{mdl_handling}{character specify values to return for measurements below the minimum detection limit choice of "raw", "half", or "full".}
}
\description{
Remove extra columns associated with QA flags, LIMS, and District recieving. Remove QA "blanks". Convert results from long to wide format.
}
\details{
Current DBHYDRO practice is to return values below the MDL as 0 minus the uncertainty estimate.
}
\examples{
\dontrun{
#check handling of values below MDL
dt <- getwq("FLAB01", "2014-09-14", "2014-09-18", "NITRATE+NITRITE-N", raw = TRUE)
cleanwq(dt, mdl_handling = "raw")
cleanwq(dt, mdl_handling = "half")
}

dt <- read.csv(system.file("extdata", "testwq.csv", package = "dbhydroR"))
cleanwq(dt)
}

