% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getset.r
\name{setters}
\alias{setters}
\alias{set_year.datetimeoffset}
\alias{set_month.datetimeoffset}
\alias{set_day.datetimeoffset}
\alias{set_hour.datetimeoffset}
\alias{set_minute.datetimeoffset}
\alias{set_second.datetimeoffset}
\alias{set_nanosecond.datetimeoffset}
\alias{set_subsecond_digits}
\alias{set_subsecond_digits.datetimeoffset}
\alias{set_hour_offset}
\alias{set_hour_offset.datetimeoffset}
\alias{set_minute_offset}
\alias{set_minute_offset.datetimeoffset}
\alias{set_tz}
\alias{set_tz.datetimeoffset}
\alias{set_tz.clock_zoned_time}
\alias{set_tz.default}
\title{Set datetime components}
\usage{
\method{set_year}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_month}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_day}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_hour}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_minute}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_second}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_nanosecond}{datetimeoffset}(x, value, ..., na_set = FALSE, digits = NULL)

set_subsecond_digits(x, value, ...)

\method{set_subsecond_digits}{datetimeoffset}(x, value, ..., na_set = FALSE)

set_hour_offset(x, value, ...)

\method{set_hour_offset}{datetimeoffset}(x, value, ..., na_set = FALSE)

set_minute_offset(x, value, ...)

\method{set_minute_offset}{datetimeoffset}(x, value, ..., na_set = FALSE)

set_tz(x, value, ...)

\method{set_tz}{datetimeoffset}(x, value, ..., na_set = FALSE)

\method{set_tz}{clock_zoned_time}(x, value, ..., nonexistent = "error", ambiguous = "error")

\method{set_tz}{default}(x, value, ...)
}
\arguments{
\item{x}{A datetime object.}

\item{value}{The replacement value.  For \code{set_day()} this can also be "last".}

\item{...}{Currently ignored.}

\item{na_set}{If \code{TRUE} set component for \code{NA} datetimes (making them no longer \code{NA})}

\item{digits}{If \code{NULL} do not update the \code{subsecond_digits} field.
Otherwise an integer vector (\code{1L} through \code{9L} or \code{NA_integer_})
to update the \code{subsecond_digits} field with.}

\item{nonexistent}{What to do when the "clock time" in the new time zone doesn't exist.
See \code{\link[clock:as-zoned-time-naive-time]{clock::as_zoned_time.clock_naive_time()}}.}

\item{ambiguous}{What to do when the "clock time" in the new time zone is ambiguous.
See \code{\link[clock:as-zoned-time-naive-time]{clock::as_zoned_time.clock_naive_time()}}.}
}
\value{
A datetime object.
}
\description{
Setter methods for \code{\link[=datetimeoffset]{datetimeoffset()}} objects.
}
\details{
We implement \code{\link[=datetimeoffset]{datetimeoffset()}} support for the following S3 methods from \code{clock}:
\itemize{
\item \code{set_year()}
\item \code{set_month()}
\item \code{set_day()}
\item \code{set_hour()}
\item \code{set_minute()}
\item \code{set_second()}
\item \code{set_nanosecond()}
}

We also implemented new S3 setter methods:
\itemize{
\item \code{set_hour_offset()}
\item \code{set_minute_offset()}
\item \code{set_tz()} (changes system time but not clock time)
}

We also implement \code{\link[=datetimeoffset]{datetimeoffset()}} support for the following S4 methods from \code{lubridate}:
\itemize{
\item \verb{year<-()}
\item \verb{month<-()}
\item \verb{day<-()}
\item \verb{hour<-()}
\item \verb{minute<-()}
\item \verb{second<-()}
\item \verb{date<-()}
}
}
\examples{
library("clock")
dt <- NA_datetimeoffset_
dt <- set_year(dt, 1918L, na_set = TRUE)
dt <- set_month(dt, 11L)
dt <- set_day(dt, 11L)
dt <- set_hour(dt, 11L)
dt <- set_minute(dt, 11L)
dt <- set_second(dt, 11L)
dt <- set_nanosecond(dt, 123456789L)
dt <- set_subsecond_digits(dt, 4L)
dt <- set_hour_offset(dt, 0L)
dt <- set_minute_offset(dt, 0L)
dt <- set_tz(dt, "Europe/Paris")
format(dt)

if (require("lubridate")) {
  dt <- datetimeoffset(0L)
  year(dt) <- 1918L
  month(dt) <- 11L
  day(dt) <- 11L
  hour(dt) <- 11L
  minute(dt) <- 11L
  second(dt) <- 11L
  if (packageVersion("lubridate") > '1.8.0' &&
      "Europe/Paris" \%in\% OlsonNames()) {
    tz(dt) <- "Europe/Paris"
  }
  format(dt)
}
}
