% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_internal.R
\name{patristic_matrix_array_subset_both}
\alias{patristic_matrix_array_subset_both}
\title{Are all desired taxa in the patristic matrix array?}
\usage{
patristic_matrix_array_subset_both(
  patristic_matrix_array,
  taxa,
  phy = NULL,
  phy4 = NULL,
  dating_method = "PATHd8"
)
}
\arguments{
\item{patristic_matrix_array}{A patristic matrix array, \code{rownames} and \code{colnames} must be taxa.}

\item{taxa}{Vector of taxon names to get a subset for.}

\item{phy}{A user tree to congruify as \code{phylo} object (ape).}

\item{phy4}{A user tree to congruify in \code{phylo4} format (phylobase).}

\item{dating_method}{The method used for tree dating.}
}
\value{
A patristic matrix with ages for the target taxa.
}
\description{
\code{patristic_matrix_array_subset_both} is used inside \code{\link[=get_subset_array_dispatch]{get_subset_array_dispatch()}}.
}
