% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_sdm.R
\name{datelife_result_sdm_phylo}
\alias{datelife_result_sdm_phylo}
\title{Reconstruct a supertree from a \code{datelifeResult} object using the Super Distance Matrix (SDM) method.}
\usage{
datelife_result_sdm_phylo(datelife_result, weighting = "flat", ...)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{weighting}{A character vector indicating how much weight to give to each
tree in \code{input} during the SDM analysis. Options are:
\describe{
\item{weighting = "flat"}{All trees have equal weighting.}
\item{weighting = "taxa"}{Weight is proportional to number of taxa.}
\item{weighting = "inverse"}{Weight is proportional to 1 / number of taxa.}
}
Defaults to \code{weighting = "flat"}.}

\item{...}{
  Arguments passed on to \code{\link[=summary_matrix_to_phylo]{summary_matrix_to_phylo}}
  \describe{
    \item{\code{summ_matrix}}{Any summary patristic distance matrix, such as the ones obtained with \code{\link[=datelife_result_sdm_matrix]{datelife_result_sdm_matrix()}} or \code{\link[=datelife_result_median_matrix]{datelife_result_median_matrix()}}.}
    \item{\code{total_distance}}{Boolean. If \code{TRUE} it will divide the matrix in half, if
\code{FALSE} it will take it as is.}
    \item{\code{use}}{A character vector indicating what type of age to use for summary.
One of the following:
\describe{
\item{mean}{It will use the mean of the node age distributions.}
\item{min}{It will use the minimum age from the node age distributions.}
\item{max}{Choose this if you wanna be conservative; it will use the maximum
age from the node age distributions.}
}}
    \item{\code{target_tree}}{A \code{phylo} object. Use this in case you want a specific
backbone for the output tree.}
    \item{\code{datelife_query}}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}
  }}
}
\value{
A supertree with branch lengths proportional to time, obtained by
summarizing individual chronograms given as input in \code{datelife_result}.
It is returned as an object of class \code{datelifeSDM}, which is a \code{phylo} object
with an additional \verb{$data} element storing the input chronograms as a
\code{datelifeResult} object, and a \verb{$citation} element containing
citations of studies from input chronograms.
}
\description{
Reconstruct a supertree from a \code{datelifeResult} object using the Super Distance Matrix (SDM) method.
}
\details{
Chronograms given as input in \code{datelife_result} are summarized with the Super Distance
Matrix (SDM) method described in Criscuolo et al. (2006) \doi{10.1080/10635150600969872},
implemented with the function \code{\link[ape:SDM]{ape::SDM()}}. The resulting summary SDM is
clustered with \code{\link[=summary_matrix_to_phylo]{summary_matrix_to_phylo()}}.
}
\references{
Criscuolo A, Berry V, Douzery EJ, Gascuel O.
(2006) "SDM: a fast distance-based approach for (super) tree building in
phylogenomics" \doi{10.1080/10635150600969872}.
}
