% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibama.R
\name{load_ibama}
\alias{load_ibama}
\title{IBAMA - Brazilian Institute for the Environment and Renewable Natural Resources}
\usage{
load_ibama(
  dataset = "areas_embargadas",
  raw_data,
  geo_level = "municipality",
  language = "eng",
  legal_amazon_only = FALSE
)
}
\arguments{
\item{dataset}{A dataset name ("areas_embargadas")}

\item{raw_data}{A \code{boolean} setting the return of raw or processed data}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be only "municipality".}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported.}

\item{legal_amazon_only}{A \code{boolean} setting the return of Legal Amazon Data or not}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on on environmental fines at the municipality or state levels considering the Amazon region
}
\examples{
\dontrun{
# download raw data from all country
raw_ibama_all <- load_ibama(dataset = "areas_embargadas",
                            raw_data = TRUE,
                            legal_amazon_only = FALSE)
}

}
