% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_sd.R
\name{mean_sd}
\alias{mean_sd}
\alias{median_mad}
\title{Summary Helpers}
\usage{
mean_sd(x, times = 1L, na.rm = TRUE, named = TRUE, ...)

median_mad(x, times = 1L, na.rm = TRUE, constant = 1.4826, named = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector (or one that can be coerced to one via
\code{as.numeric()}) to be summarized.}

\item{times}{How many SDs above and below the Mean (or MADs around the Median)}

\item{na.rm}{if \code{TRUE} then \code{NA} values are stripped
    from \code{x} before computation takes place.}

\item{named}{Should the vector be named?
(E.g., \code{c("-SD" = -1, Mean = 1, "+SD" = 2)}.)}

\item{...}{Not used.}

\item{constant}{scale factor.}
}
\value{
A (possibly named) numeric vector of length \code{2*times + 1} of SDs
below the mean, the mean, and SDs above the mean (or median and MAD).
}
\description{
Summary Helpers
}
\examples{
mean_sd(mtcars$mpg)

mean_sd(mtcars$mpg, times = 2L)

median_mad(mtcars$mpg)

}
