% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_diffs.R
\name{summarise_diffs}
\alias{summarise_diffs}
\title{Summarise diffs}
\usage{
summarise_diffs(destination)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}
}
\value{
a data frame of diff statistics
}
\description{
Create a data frame which summarises the diffs in a versioned dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
new_df <- data.frame(a = 2:5, b = letters[2:5])
diff <- diffdfs::diffdfs(new_df, df)
commit_diff(diff, temp_dir)

summarise_diffs(temp_dir)

unlink(temp_dir)

}
