% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_backup.R
\name{delete_backup}
\alias{delete_backup}
\title{Delete backup}
\usage{
delete_backup(destination, after_position, verbose = FALSE)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{after_position}{how many backups should we leave in the dv?}

\item{verbose}{TRUE /FALSE should the function be chatty?}
}
\value{
TRUE
}
\description{
Delete backups after a particular position in a versioned dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
for(i in 1:10) {put_backup(df, temp_dir)}

# before
list.files(file.path(temp_dir, "backup"))

delete_backup(temp_dir, 4L)

# after
list.files(file.path(temp_dir, "backup"))

}
