% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_evita10_uf.R
\name{sim_evita10_uf}
\alias{sim_evita10_uf}
\title{Scrapes SIM's ICD-10 evitable causes data from ufs}
\usage{
sim_evita10_uf(uf, linha = "Município", coluna = "Não ativa",
  conteudo = 1, periodo = "last", municipio = "all", cir = "all",
  macrorregiao_de_saude = "all", divisao_admnist_estadual = "all",
  microrregiao_ibge = "all", ride = "all", causas_evitaveis = "all",
  capitulo_cid10 = "all", categoria_cid10 = "all", faixa_etaria = "all",
  sexo = "all", cor_raca = "all", escolaridade = "all", estado_civil = "all",
  local_ocorrencia = "all")
}
\arguments{
\item{uf}{A character of length = 1 with the state's acronym of interest.}

\item{linha}{A character describing which element will be displayed in the rows of the data.frame. Defaults to "Município".}

\item{coluna}{A character describing which element will be displayed in the columns of the data.frame. Defaults to "Não ativa".}

\item{conteudo}{A character of length = 1 with the state's acronym of interest.}

\item{periodo}{A character vector describing the period of data. Defaults to the last available.}

\item{municipio}{"all" or a numeric vector with the IBGE's city codes codes to filter the data. Defaults to "all".}

\item{cir}{"all" or a numeric vector with the CIR's codes to filter the data. Defaults to "all".}

\item{macrorregiao_de_saude}{"all" or a numeric vector with the Health macro-region's codes to filter the data. Defaults to "all".}

\item{divisao_admnist_estadual}{"all" or a numeric vector with the State administrative division's codes to filter the data. Defaults to "all".}

\item{microrregiao_ibge}{"all" or a numeric vector with the IBGE's micro-region codes to filter the data. Defaults to "all".}

\item{ride}{"all" or a numeric vector with the IBGE's metropolitan-region codes to filter the data. Defaults to "all".}

\item{causas_evitaveis}{"all" or a character vector with the evitable cause code (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{capitulo_cid10}{"all" or a numeric vector with the ICD-10 chapter to filter the data. Defaults to "all".}

\item{categoria_cid10}{"all" or a character vector with the ICD-10 category codes (capital letter and two numbers) to filter the data. Defaults to "all".}

\item{faixa_etaria}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{sexo}{"all" or a character vector with the gender (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{cor_raca}{"all" or a character vector with the color/race (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{escolaridade}{"all" or a character vector with the instruction (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{estado_civil}{"all" or a character vector with the marital status (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{local_ocorrencia}{"all" or a character vector with the place of ocurrence to filter the data. Defaults to "all".}
}
\value{
The function returns a data frame printed by parameters input.
}
\description{
This function allows the user to retrive data from
SIM's ICD-10 database much in the same way that is done
by the online portal. The argument options refer to
evitable causes in 0-4 age group data from the states
unities.
}
\examples{
\dontrun{
## Requesting data from the state of Mato Grosso do Sul
sim_evita10_uf(uf = "ms")
}

}
\seealso{
\code{\link{sim_obt10_mun}}
}
\author{
Renato Prado Siqueira \email{<rpradosiqueira@gmail.com>}
}
\keyword{SIM}
\keyword{causas}
\keyword{datasus}
\keyword{evitáveis}
