% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spice_to_eml.R
\name{spice_to_eml}
\alias{spice_to_eml}
\title{Convert \code{dataspice} metadata to EML}
\usage{
spice_to_eml(spice = file.path("data", "metadata", "dataspice.json"))
}
\arguments{
\item{spice}{(list) Your \code{dataspice} metadata. Uses
\code{data/metadata/dataspice.json} by default.}
}
\value{
(emld) The crosswalked \code{emld} object
}
\description{
Performs an (imperfect) conversion of \code{dataspice} metadata to EML. It's
very likely you will get validation errors and need to fix them afterwards
but \code{spice_to_eml} is a good way to a richer metadata schema (EML) when
you're already using \code{dataspice} but need a richer metadata schema.
}
\examples{
# Load an example dataspice JSON that comes installed with the package
spice <- system.file(
  "examples", "annual-escapement.json",
  package = "dataspice")

# And crosswalk it to EML
spice_to_eml(spice)

# We can also create dataspice metadata from scratch and crosswalk it to EML
myspice <- list(
  name = "My example spice",
  creator = "Me",
  contact = "Me")
spice_to_eml(myspice)
}
