% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dataset_json.R
\name{write_dataset_json}
\alias{write_dataset_json}
\title{Write out a Dataset JSON file}
\usage{
write_dataset_json(x, file, pretty = FALSE)
}
\arguments{
\item{x}{datasetjson object}

\item{file}{File path to save Dataset JSON file}

\item{pretty}{If TRUE, write with readable formatting}
}
\value{
NULL when file written to disk, otherwise character string
}
\description{
Write out a Dataset JSON file
}
\examples{
# Write to character object
ds_json <- dataset_json(iris, "IG.IRIS", "IRIS", "Iris", iris_items)
js <- write_dataset_json(ds_json)

# Write to disk
\dontrun{
  write_dataset_json(ds_json, "path/to/file.json")
}
}
