% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_metadata.R
\name{data_metadata}
\alias{data_metadata}
\title{Create the data metadata container for a Dataset JSON object}
\usage{
data_metadata(study = "NA", metadata_version = "NA", metadata_ref = "NA")
}
\arguments{
\item{study}{Study OID value}

\item{metadata_version}{Metadata version OID value}

\item{metadata_ref}{Metadata reference (i.e. path to Define.xml)}
}
\value{
data_metadata object
}
\description{
Create the data metadata container for a Dataset JSON object
}
\examples{
# Create object directly
data_meta <- data_metadata(
  study = "SOMESTUDY",
  metadata_version = "MDV.MSGv2.0.SDTMIG.3.3.SDTM.1.7",
  metadata_ref = "some/define.xml"
)

# Use setter functions
data_meta <- data_metadata()
data_meta_updated <- set_metadata_ref(data_meta, "some/define.xml")
data_meta_updated <- set_metadata_version(data_meta_updated, "MDV.MSGv2.0.SDTMIG.3.3.SDTM.1.7")
data_meta_updated <- set_study_oid(data_meta_updated, "SOMESTUDY")

}
