% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provenance.R
\name{default_provenance}
\alias{default_provenance}
\title{Build default provenance bundle}
\usage{
default_provenance(
  dataset_id = "http://example.com/dataset#",
  author = NULL,
  dtm = NULL,
  generated_at_time = NULL
)
}
\arguments{
\item{dataset_id}{Base IRI for the dataset (used as the \code{Entity} subject).}

\item{author}{Optional creator/author agent.}

\item{dtm}{Optional data team/maintainer agent.}

\item{generated_at_time}{Optional POSIXct time; defaults to \code{\link[=Sys.time]{Sys.time()}}.}
}
\value{
A character vector of N‑Triples suitable for the \code{"prov"} attribute.
}
\description{
Construct a small PROV bundle (as N‑Triples) describing the dataset, the
software agent, and an optional creation time.
}
\details{
This helper is used internally to seed provenance metadata. It emits a set of
PROV statements including an \code{Entity} for the dataset, an \code{Activity} for
creation, and \code{SoftwareAgent} entries for the package citation.
}
\keyword{internal}
