% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_format.R
\name{dataset_format}
\alias{dataset_format}
\alias{dataset_format<-}
\title{Get or set the technical format of a dataset}
\usage{
dataset_format(x)

dataset_format(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A semantically rich data frame created with \code{\link[=dataset_df]{dataset_df()}} or
\code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. Replace an existing non‑default value? If \code{FALSE}
and a non‑default value already exists, a message is emitted and the value
is kept. Defaults to \code{FALSE}.}

\item{value}{A length‑one character string specifying the format
(e.g., \code{"text/csv"}). Use \code{NULL} to reset to the default.}
}
\value{
The \code{"format"} (technical format) as a character string (length 1).
When assigning, the updated object \code{x} is returned invisibly.
}
\description{
Adds or retrieves the optional \code{"format"} field of a dataset's bibentry.
This field is the dataset's technical/media type (e.g., a MIME type).
}
\details{
The format field corresponds to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/format/}{dct:format}
in Dublin Core and to \code{format} in
\href{https://schema.datacite.org/}{DataCite}.
It is useful for indicating serialization such as \code{"text/csv"},
\code{"application/parquet"}, or \code{"application/r-rds"}.

If no format is set, this helper uses the package default
\code{"application/r-rds"}.
}
\examples{
dataset_format(orange_df) <- "text/csv"
dataset_format(orange_df)

# Reset to the package default
dataset_format(orange_df) <- NULL

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
