% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_triple.R
\name{n_triples}
\alias{n_triples}
\title{Create N-Triples}
\usage{
n_triples(triples)
}
\arguments{
\item{triples}{Concatenated N-Triples created with \code{\link{n_triple}}.}
}
\value{
A character vector containing unique N-Triple strings.
}
\description{
Create triple statements to annotate your dataset with standard,
interoperable metadata.
}
\details{
N-Triples is an easy to parse line-based subset of Turtle to serialize
RDF. See
\href{https://www.w3.org/TR/rdf12-n-triples/}{RDF 1.2 N-Triples. A line-based syntax for an RDF graph}.
}
\examples{
triple_1 <- n_triple(
  "http://example.org/show/218",
  "http://www.w3.org/2000/01/rdf-schema#label",
  "That Seventies Show"
)
triple_2 <- n_triple(
  "http://example.org/show/218",
  "http://example.org/show/localName",
  '"Cette Série des Années Septante"@fr-be'
)
n_triples(c(triple_1, triple_2, triple_1))
}
