% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocation.R
\name{geolocation}
\alias{geolocation}
\alias{geolocation<-}
\title{Get/set the Geolocation of the object.}
\usage{
geolocation(x)

geolocation(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A semantically rich data frame object created by
\code{dataset::\link{dataset_df}} or \code{dataset::\link{as_dataset_df}}.}

\item{overwrite}{If the attributes should be overwritten. In case it is set
to \code{FALSE}, it gives a message with the current \code{Geolocation}
property instead of overwriting it. Defaults to \code{TRUE} when the
attribute is set to \code{value} regardless of previous setting.}

\item{value}{The  \code{Geolocation} as a character string.}
}
\value{
The \code{Geolocation} attribute as a character of length 1 is added
to \code{x}.
}
\description{
Get/set the optional \code{Geolocation} property as an attribute
to an R object.
}
\details{
The \code{Geolocation} is recommended for discovery in DataCite 4.4.
Spatial region or named place where the data was gathered or about which
the data is focused. See:
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#18-geolocation}{datacite:Geolocation}.
}
\examples{
orange_dataset <- orange_df
geolocation(orange_df) <- "US"
geolocation(orange_df)

geolocation(orange_df, overwrite = FALSE) <- "GB"

}
\seealso{
Other Reference metadata functions: 
\code{\link{description}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()}
}
\concept{Reference metadata functions}
