% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_to_column.R
\name{id_to_column}
\alias{id_to_column}
\title{Add identifier to columns}
\usage{
id_to_column(x, prefix = "eg:", ids = NULL)
}
\arguments{
\item{x}{An R object that contains the data of the dataset (a data.frame or
inherited from \code{\link[base:data.frame]{data.frame}}), for example,
\code{\link[tibble:tibble]{tibble::tibble()}}, \code{\link[tsibble:tsibble]{tsibble::tsibble()}}, \code{\link[data.table:data.table]{data.table::data.table()}}.}

\item{prefix}{Defaults to \code{eg:} (example.com).}

\item{ids}{Defaults to \code{NULL}.}
}
\value{
A dataset conforming the original sub-class of \code{x}.
}
\description{
Add a prefixed identifier to the first column of the dataset.
}
\examples{

# Example with a dataaset object:
id_to_column(iris_dataset)

# Example with a data.frame object:

id_to_column(iris, prefix="eg:iris-o")
}
