% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datasaurus-package.r
\docType{data}
\name{datasaurus_dozen}
\alias{datasaurus_dozen}
\title{Datasaurus Dozen data}
\format{A data frame with 1846 rows and 3 variables:
\itemize{
\item \strong{dataset}: indicates which dataset the data are from
\item \strong{x}: x-values
\item \strong{y}: y-values
}}
\usage{
datasaurus_dozen
}
\description{
A dataset demonstrating the utility of visualization. These 12 datasets are equal in standard measures: mean,
standard deviation, and Pearson's correlation.
}
\examples{
if(require(ggplot2)){
  ggplot(datasaurus_dozen, aes(x=x, y=y, colour=dataset))+
    geom_point()+
    theme_void()+
    theme(legend.position = "none")+
    facet_wrap(~dataset, ncol=3)
}
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.autodeskresearch.com/publications/samestats}.
}
\keyword{datasets}
