% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDeployment.R
\name{RequestModelDeployment}
\alias{RequestModelDeployment}
\title{Request a model deployment.}
\usage{
RequestModelDeployment(project, modelId, label, instanceId = NULL,
  description = NULL, status = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}

\item{label}{character. A name for the model deployment.}

\item{instanceId}{character. Optional. Id of the instance in DataRobot cloud being deployed to.}

\item{description}{character. Optional. Description for the model deployment.}

\item{status}{character. Optional. status for the model deployment. Can be "active",
"inactive" or "archived". Defaults to "active".}
}
\value{
job Id
}
\description{
Request a model deployment.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  RequestModelDeployment(projectId, modelId, label = "My Deployment")
}
}
