% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasonCodes.R
\name{DownloadReasonCodes}
\alias{DownloadReasonCodes}
\title{Function to download and save reason codes rows as csv file}
\usage{
DownloadReasonCodes(project, reasonCodeId, filename, encoding = "UTF-8")
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{reasonCodeId}{character. id of the reason codes.}

\item{filename}{character. Fileneme of file to save reason codes rows}

\item{encoding}{character. Optional. Character string A string representing the encoding
to use in the output file, defaults to 'UTF-8'.}
}
\value{
Logical TRUE and displays a message to the user if the delete
  request was successful; otherwise an error message is displayed.
}
\description{
Function to download and save reason codes rows as csv file
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModelObject(model, datasetId)
  jobId <- RequestReasonCodes(model, datasetId)
  reasonCodeId <- GetReasonCodesMetadataFromJobId(projectId, jobId)
  DownloadReasonCodes(projectId, reasonCodeId, "testReasonCode.csv")
}
}
