% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSources.R
\name{GetDataSource}
\alias{GetDataSource}
\title{Returns information about a particular data source.}
\usage{
GetDataSource(dataSourceId)
}
\arguments{
\item{dataSourceId}{character. The id of the data source}
}
\value{
A list containing information on the particular data source:
\itemize{
  \item className character. The Java class name of the driver.
  \item baseNames character. A vector of the file name(s) of the jar files.
  \item canonicalName character. The user-friendly name of the driver.
  \item id character. The dataSourceId of the driver.
  \item creator character. The userId of the user who created the driver.
}
}
\description{
Returns information about a particular data source.
}
\examples{
\dontrun{
 dataSourceId <- "57a7c978c808916f4a630f89"
 GetDataSource(dataSourceId)
}
}
