% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{GetRatingTableModel}
\alias{GetRatingTableModel}
\title{Retrieve information about specified model with a rating table.}
\usage{
GetRatingTableModel(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}
}
\value{
list containing information about specified model with a rating table.
}
\description{
Retrieve information about specified model with a rating table.
}
\examples{
\dontrun{
 projectId <- "5984b4d7100d2b31c1166529"
 modelId <- "5984b4d7100d2b31c1166529"
 GetRatingTableModel(projectId, modelId)
}
}
