% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StarredModels.R
\name{ToggleStarForModel}
\alias{ToggleStarForModel}
\title{Star a model if it is unstarred, otherwise unstar the model.}
\usage{
ToggleStarForModel(model)
}
\arguments{
\item{model}{character. The model for which you want to compute Feature Impact, e.g.
from the list of models returned by \code{ListModels(project)}.}
}
\value{
the model object, but now starred if unstarred or unstarred if starred.
}
\description{
Star a model if it is unstarred, otherwise unstar the model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  ToggleStarForModel(model)
}
}
