## ---- echo = FALSE-------------------------------------------------------
library(knitr)
data <- data.frame(row = seq(9),
                   time = as.Date("2017-01-02") + seq(9),
                   target = c(16443, 3013, 1643, rep(NA, 6)),
                   temp = c(72, 72, 68, rep(NA, 6)))
kable(data)

## ---- echo = FALSE-------------------------------------------------------
library(knitr)
data <- data.frame(row = seq(9),
                   time = as.Date("2017-01-02") + seq(9),
                   target = c(16443, 3013, 1643, rep(NA, 6)),
                   holiday = c(TRUE, rep(FALSE, 5), TRUE, rep(FALSE, 2)))
kable(data)

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    useTimeSeries = TRUE)
#  StartProject(dataSource = data, target = "target", partition = partition, metric = "RMSE")

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    featureDerivationWindowStart = -24,
#                                                    featureDerivationWindowEnd = -12,
#                                                    useTimeSeries = TRUE)

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    forecastWindowStart = 1,
#                                                    forecastWindowEnd = 10,
#                                                    useTimeSeries = TRUE)

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  predictions <- Predict(timeSeriesModel, testData, forecastPoint = "1958-01-01")

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  project <- SetupProject(dataSource = data, projectName = "test-TimeSeries")
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    useTimeSeries = TRUE,
#                                                    featureSettings = list("featureName" = "holiday",
#                                                                           "defaultToKnownInAdvance" = TRUE))
#  SetTarget(project = project,
#            target = "target",
#            partition = partition,
#            metric = "RMSE")

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    useTimeSeries = TRUE,
#                                                    featureSettings = list(list("featureName" = "holiday",
#                                                                                "defaultToKnownInAdvance" = TRUE),
#                                                                           list("featureName" = "weekend",
#                                                                                "defaultToKnownInAdvance" = TRUE)))

## ----results = "asis", message = FALSE, warning = FALSE, eval = FALSE----
#  data <- read.csv("multiseries.csv")
#  project <- SetupProject(dataSource = data, projectName = "test-MultiSeries")
#  partition <- CreateDatetimePartitionSpecification(datetimePartitionColumn = "timestamp",
#                                                    useTimeSeries = TRUE,
#                                                    multiseriesIdColumns = list("series_id"))
#  SetTarget(project = project,
#            target = "target",
#            partition = partition,
#            metric = "RMSE",
#            mode = AutopilotMode$Manual,
#            targetType = "Regression")

