% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_apply_schema.R
\name{dp_apply_schema}
\alias{dp_apply_schema}
\title{Convert columns of data.frame to their correct types using table schema}
\usage{
dp_apply_schema(
  dta,
  resource,
  convert_categories = c("no", "to_factor", "to_code"),
  ...
)
}
\arguments{
\item{dta}{a \code{data.frame} or \code{data.table}.}

\item{resource}{an object with the Data Resource of the data set.}

\item{convert_categories}{how to handle columns for which the field
descriptor has a \code{categories} property.  This should either be the
strings "no", "to_factor", "to_code", the name of a function or a function.
When equal to "no" the field is returned as is; when equal to "to_factor"
each column is transformed using \code{\link{dp_to_factor}}; when equal to
"to_code" each column is transformed using \code{\link{dp_to_code}}. In
other cased the function is called with the column as its first parameter and
\code{warn = FALSE} as its second argument. The result of this function call
is added to the resulting data set.}

\item{...}{additional arguments are passed on to the \code{dp_to_<fieldtype>}
functions (e.g. \code{\link{dp_to_number}}).}
}
\value{
Returns a copy of the input data.frame with columns modified to match the
types given in de table schema.
}
\description{
Convert columns of data.frame to their correct types using table schema
}
\details{
Converts each column in \code{dta} to the correct R-type using the type
information in the table schema. For example, if the original column type in
\code{dta} is a character vector and the table schema specifies that the field is
of type number, the column is converted to numeric using the decimal
separator and thousands separator specified in the field descriptor (or default values
for these if not).
}
\seealso{
This function calls conversion functions for each of the columns, see 
\code{\link{dp_to_number}}, \code{\link{dp_to_boolean}}, \code{\link{dp_to_integer}}, 
\code{\link{dp_to_date}}. \code{\link{dp_to_datetime}}, \code{\link{dp_to_yearmonth}}, 
and \code{\link{dp_to_string}}.
}
