/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;
import com.hp.hpl.jena.sparql.util.Utils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestClassify
extends TestCase {
    public static Test suite() {
        TestSuite ts = new TestSuite(TestClassify.class);
        ts.setName(Utils.classShortName(TestClassify.class));
        return ts;
    }

    public void testClassify_Join_01() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(true) } }", true);
    }

    public void testClassify_Join_02() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(?s) } }", true);
    }

    public void testClassify_Join_03() {
        this.classifyJ("{?s :p :o . { ?s :p ?o FILTER(?o) } }", true);
    }

    public void testClassify_Join_04() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(?o) } }", true);
    }

    public void testClassify_Join_05() {
        this.classifyJ("{?s :p :o . { ?x :p :o FILTER(?s) } }", false);
    }

    public void testClassify_Join_06() {
        this.classifyJ("{ { ?s :p :o FILTER(true) } ?s :p :o }", true);
    }

    public void testClassify_Join_07() {
        this.classifyJ("{ { ?s :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    public void testClassify_Join_08() {
        this.classifyJ("{ { ?s :p ?o FILTER(?o) }   ?s :p :o }", true);
    }

    public void testClassify_Join_09() {
        this.classifyJ("{ { ?s :p :o FILTER(?o) }   ?s :p :o }", true);
    }

    public void testClassify_Join_10() {
        this.classifyJ("{ { ?x :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    public void testClassify_Join_11() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o } } }", false);
    }

    public void testClassify_Join_12() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o FILTER(?s) } } }", false);
    }

    public void testClassify_Join_13() {
        this.classifyJ("{?s :p :o . { ?x :p :o OPTIONAL { :s :p :o FILTER(?x) } } }", true);
    }

    public void testClassify_Join_14() {
        this.classifyJ("{?s :p :o . { OPTIONAL { :s :p :o FILTER(?o) } } }", true);
    }

    public void testClassify_Join_15() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?x :p :o FILTER(?s) } } }", false);
    }

    public void testClassify_Join_20() {
        this.classifyJ("{ {?s :p ?x } . { {} OPTIONAL { :s :p ?x } } }", false);
    }

    public void testClassify_Join_21() {
        this.classifyJ("{ { {} OPTIONAL { :s :p ?x } } {?s :p ?x } }", true);
    }

    private void classifyJ(String pattern, boolean expected) {
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create(qs);
        Op op = Algebra.compile(query.getQueryPattern());
        if (!(op instanceof OpJoin)) {
            TestClassify.fail((String)("Not a join: " + pattern));
        }
        boolean nonLinear = JoinClassifier.isLinear((OpJoin)op);
        TestClassify.assertEquals((String)("Join: " + pattern), (boolean)expected, (boolean)nonLinear);
    }

    public void testClassify_LeftJoin_01() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?x} }", true);
    }

    public void testClassify_LeftJoin_02() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 ?p2 ?x} } }", true);
    }

    public void testClassify_LeftJoin_03() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?o3} } }", true);
    }

    public void testClassify_LeftJoin_04() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?x} } }", false);
    }

    private void classifyLJ(String pattern, boolean expected) {
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create(qs);
        Op op = Algebra.compile(query.getQueryPattern());
        if (!(op instanceof OpLeftJoin)) {
            TestClassify.fail((String)("Not a leftjoin: " + pattern));
        }
        boolean nonLinear = LeftJoinClassifier.isLinear((OpLeftJoin)op);
        TestClassify.assertEquals((String)("LeftJoin: " + pattern), (boolean)expected, (boolean)nonLinear);
    }
}

