/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuildException;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import com.hp.hpl.jena.sparql.sse.builders.BuilderGraph;
import com.hp.hpl.jena.sparql.sse.builders.BuilderOp;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;

public class BuilderExec {
    public static void main(String[] argv) {
        Item item = SSE.readFile("SSE/all.sse");
        BuilderExec.exec(item);
    }

    public static void exec(Item item) {
        if (item.isNode()) {
            BuilderBase.broken(item, "Attempt to build evaluation from a plain node");
        }
        if (item.isSymbol()) {
            BuilderBase.broken(item, "Attempt to build evaluation from a bare symbol");
        }
        if (!item.isTagged("exec")) {
            throw new BuildException("Wanted (exec...) : got: " + item.shortString());
        }
        ItemList list = item.getList();
        BuilderBase.checkLength(3, list, item.shortString() + " does not have 2 components");
        DatasetGraph dsg = BuilderGraph.buildDataset(list.get(1));
        Op op = BuilderOp.build(list.get(2));
        QueryExecUtils.executeAlgebra(op, dsg, ResultsFormat.FMT_TEXT);
    }
}

