% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R, R/CNode.R, R/MNode.R
\docType{methods}
\name{getObject}
\alias{getObject}
\alias{getObject,CNode-method}
\alias{getObject,MNode-method}
\title{Get the bytes associated with an object on this Node.}
\usage{
getObject(x, ...)

\S4method{getObject}{CNode}(x, pid)

\S4method{getObject}{MNode}(x, pid, check = as.logical(FALSE))
}
\arguments{
\item{x}{The Node instance from which the pid will be downloaded}

\item{...}{(Not yet used).}

\item{pid}{The identifier of the object to be downloaded}

\item{check}{A logical value, if TRUE check if this object has been obsoleted by another object in DataONE.}
}
\value{
the bytes of the object
}
\description{
Get the bytes associated with an object on this Node.
}
\details{
This operation acts as the 'public' anonymous user unless an X.509 certificate is
present in the default location of the file system, in which case the access will be authenticated.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
pid <- "solson.5.1"
obj <- getObject(mn, pid)
df <- read.csv(text=rawToChar(obj))
}
}
\seealso{
\code{\link{D1Node-class}{D1Node}}{ class description.}
}

