% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pinusSpp}
\alias{pinusSpp}
\title{Tree-level variables of invasive of Pinus spp in Chile.}
\format{
Contains 8 variables, as follows:
\describe{
\item{plot.id}{Plot sample ID.}
\item{size.plot}{Plot size in square meters.}
\item{Lat.s}{Decimal coordinate of S latitude.}
\item{Long.w}{Decimal coordinate of W longitude.}
\item{indv.id}{Tree identificator number in each plot. Same indv/id for multi-stem trees.}
\item{stem.id}{Stem identificator number in each plot.}
\item{sp}{Specie.}
\item{dbh}{Diameter at breast height on trees, in cm.}
\item{h}{Height of trees, in m.}
\item{canopy.h}{Height at which the live canopy begins, in m.}
\item{canopy.lenght}{Lenght of live canopy, in m.}
\item{obs}{Extra information.}
}
}
\source{
The data are provided courtesy of Drs. Anibal Pauchard and Rafael Garcia at the Laboratorio de Invasiones
 Biologicas, Universidad de Concepcion (Chile).
}
\usage{
data(pinusSpp)
}
\description{
These are tree-lavel measurement data from Pinus spp invasion in Araucaria-Nothofagus forests in 
the Malalcahuello National Reserve in La Araucania region in southhern Chile, measured in 2012. 
The plots area was 100 square meters
}
\examples{
data(pinusSpp)    
head(pinusSpp) 
}
\references{
Cobar-Carranza A, Garcia R, Pauchard A & Pena E. 2014. Effect of Pinus contorta invasion on forest fuel properties and
 its potential implications on the fire regime of Araucaria araucana and Nothofagus antarctica forests.
 Biological Invasions. 16(11): 2273 - 2291
}
\keyword{datasets}
