% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_col_as.R
\name{set_col_as_character}
\alias{set_col_as_character}
\title{Set columns as character}
\usage{
set_col_as_character(data_set, cols = "auto", verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of data_set to transform into characters. To transform
all columns, set it to "auto". (characters, default to "auto")}

\item{verbose}{Should the function log (logical, default to TRUE)}
}
\value{
data_set (as a \code{\link{data.table}}), with specified columns set as character.
}
\description{
Set as character a column (or a list of columns) from a data.table.
}
\examples{
# Build a fake data.frame
data_set <- data.frame(numCol = c(1, 2, 3), factorCol = as.factor(c("a", "b", "c")))

# Set numCol and factorCol as character
data_set <- set_col_as_character(data_set, cols = c("numCol", "factorCol"))
}
