% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_prepareData.R
\name{prepareData}
\alias{prepareData}
\title{prepareData Prepares data for comparison in 3 stages.
            1. Match columns - filter dataframes to those columns that match and summarise differences
            2. Match rows - filter dataframes to those rows that match and summarise differences
            3. Coerce data}
\usage{
prepareData(dfA, dfB, keys = NA, trimChars = T)
}
\arguments{
\item{dfA}{data frame. The first data object. dataCompareR will attempt to coerce all data objects to data frames.}

\item{dfB}{data frame. The second data object. dataCompareR will attempt to coerce all data objects to data frames.}

\item{keys}{String. Name of identifier column(s) used to compare dfA and dfB. NA if no identifier (row order will be used instead), 
a character for a single column name, or a vector of column names to match of multiple columns}

\item{trimChars}{Boolean. If true, strings and factors have whitespace trimmed before comparison.}
}
\value{
\code{dataCompareRObject} containing details of the comparison
}
\description{
prepareData Prepares data for comparison in 3 stages.
            1. Match columns - filter dataframes to those columns that match and summarise differences
            2. Match rows - filter dataframes to those rows that match and summarise differences
            3. Coerce data
}
\examples{
\dontrun{dfA <- iris}
\dontrun{dfB <- iris}
\dontrun{keys <- NA}
\dontrun{prepareData(dfA,dfB,keys, trimChars = T)}
}
