% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{DefaultPlotHeight}
\alias{DefaultPlotHeight}
\title{Calculates the height of a \code{Node} given the height of the root.}
\usage{
DefaultPlotHeight(node, rootHeight = 100)
}
\arguments{
\item{node}{The node}

\item{rootHeight}{The height of the root}
}
\description{
This function puts leafs at the bottom (not hanging), and makes edges equally long.
Useful for easy plotting with third-party packages, e.g. if you have no specific height 
attribute, e.g. with \code{\link{as.dendrogram.Node}}, \code{\link{ToNewick}}, 
and \code{\link{as.phylo.Node}}
}
\examples{
data(acme)
dacme <- as.dendrogram(acme, heightAttribute = function(x) DefaultPlotHeight(x, 200))
plot(dacme, center = TRUE)
  
}

