% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2vcf.r
\name{gl2vcf}
\alias{gl2vcf}
\title{Converts a genlight object into vcf format}
\usage{
gl2vcf(
  x,
  plink_path = getwd(),
  outfile = "gl_vcf",
  outpath = tempdir(),
  snp_pos = "0",
  snp_chr = "0",
  chr_format = "character",
  pos_cM = "0",
  ID_dad = "0",
  ID_mom = "0",
  sex_code = "unknown",
  phen_value = "0",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{plink_path}{Path of PLINK binary file [default getwd())].}

\item{outfile}{File name of the output file [default 'gl_vcf'].}

\item{outpath}{Path where to save the output file
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.'
 when calling this function to direct output files to your working directory.}

\item{snp_pos}{Field name from the slot loc.metrics where the SNP position is
stored [default '0'].}

\item{snp_chr}{Field name from the slot loc.metrics where the chromosome of
each is stored [default '0'].}

\item{chr_format}{Whether chromosome information is stored as 'numeric' or as
'character', see details [default 'character'].}

\item{pos_cM}{A vector, with as many elements as there are loci, containing
the SNP position in morgans or centimorgans [default '0'].}

\item{ID_dad}{A vector, with as many elements as there are individuals,
containing the ID of the father, '0' if father isn't in dataset [default '0'].}

\item{ID_mom}{A vector, with as many elements as there are individuals,
containing the ID of the mother, '0' if mother isn't in dataset [default '0'].}

\item{sex_code}{A vector, with as many elements as there are individuals,
containing the sex code ('male', 'female', 'unknown') [default  'unknown'].}

\item{phen_value}{A vector, with as many elements as there are individuals,
containing the phenotype value. '1' = control, '2' = case, '0' = unknown
[default '0'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\description{
This function exports a genlight object into VCF format and save it into a
file.
}
\details{
This function requires to download the binary file of PLINK 1.9 and provide
its path (plink_path).
The binary file can be downloaded from:
\url{https://www.cog-genomics.org/plink/}

The chromosome information for unmapped SNPS is coded as 0.
Family ID is taken from  x$pop
Within-family ID (cannot be '0') is taken from indNames(x)
Variant identifier is taken from locNames(x)
}
\examples{
\dontrun{
require("dartR.data")
gl2vcf(platypus.gl,snp_pos='ChromPos_Platypus_Chrom_NCBIv1',
 snp_chr = 'Chrom_Platypus_Chrom_NCBIv1')
}
}
\references{
Danecek, P., Auton, A., Abecasis, G., Albers, C. A., Banks, E., DePristo, M.
 A., ... & 1000 Genomes Project Analysis Group. (2011). The variant call
 format and VCFtools. Bioinformatics, 27(15), 2156-2158.
}
\author{
Custodian: Luis Mijangos (Post to
\url{https://groups.google.com/d/forum/dartr})
}
