% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.dups.r
\name{gl.filter.dups}
\alias{gl.filter.dups}
\title{Filter duplicated loci in a genlight \{adegenet\} object}
\usage{
gl.filter.dups(gl)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data, or the genind object containing the SilocoDArT data [required]}
}
\value{
The reduced genlight or genind object, plus a summary
}
\description{
SNP datasets generated by DArT include fragments with more than one SNP and record them separately with the same CloneID (=AlleleID).
These multiple SNP loci within a fragment are likely to be linked, and so you may wish to remove duplicates.
This script filters out duplicate loci after ordering the genlight object on based on reproducibility, PIC in that order.
}
\examples{
gl <- gl.filter.dups(testset.gl)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}

