% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.excess.het.r
\name{gl.report.excess.het}
\alias{gl.report.excess.het}
\title{Report loci with excess of heterozygosity}
\usage{
gl.report.excess.het(
  x,
  Yates = FALSE,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{Yates}{Boolean for Yates's continuity correction. [default FALSE]}

\item{plot.display}{Specify if plot is to be produced [default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{Vector with two color names for the borders and fill
[default c("#2171B5", "#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
1. Table with information of excessively-heterozygous loci \cr
2. Two plots of heterozygosity of the loci before and after filtering (i.e. without excessively heterozygous loci).\cr
3. A vector with the names of loci to be remove by \code{\link{gl.filter.excess.het}}
}
\description{
Calculates excess of heterozygosity in a genlight object
}
\details{
Loci with observed heterozygosity larger than 0.5 and expected heterozygosity would be indicated as excess (p-value <= 0.05). 
You can remove the loci with excess of heterozygosity from genlight object using \code{\link{gl.filter.excess.het}}

\strong{ Function's output }

If a plot.file is given, the ggplot arising from this function is saved as an 
"RDS" binary file using saveRDS(); can be reloaded with readRDS(). A file 
name must be specified for the plot to be saved.

If a plot directory (plot.dir) is specified, the ggplot binary is saved to 
that directory; otherwise to the tempdir(). 
 
 Examples of other themes that can be used can be consulted in: 
 \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
 A color vector can be obtained with gl.select.colors() and then passed to
 the function with the plot.colors parameter.
}
\examples{
filtered.table <- gl.report.excess.het(x = LBP, Yates = TRUE)
}
\references{
\itemize{
\item https://github.com/drobledoruiz/conservation_genomics/tree/main/filter.excess.het
\item Robledo‐Ruiz, D. A., Austin, L., Amos, J. N., Castrejón‐Figueroa, J., Harley, D. K., Magrath, M. J., Sunnucks, P. & Pavlova, A. (2023). 
Easy‐to‐use R functions to separate reduced‐representation genomic datasets into sex‐linked and autosomal loci, 
and conduct sex assignment. Molecular Ecology Resources.
}
}
\seealso{
\code{\link{gl.filter.excess.het}}

Other unmatched report: 
\code{\link{gl.allele.freq}()},
\code{\link{gl.report.basics}()},
\code{\link{gl.report.diversity}()},
\code{\link{gl.report.heterozygosity}()},
\code{\link{gl.report.polyploid_heterozygosity}()}
}
\author{
Jesús Castrejón-Figueroa, Diana A Robledo-Ruiz (Custodian: Ching Ching Lau) -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{unmatched report}
