% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.secondaries.r
\name{gl.filter.secondaries}
\alias{gl.filter.secondaries}
\title{Filters loci that represent secondary SNPs in a genlight object}
\usage{
gl.filter.secondaries(x, method = "random", verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{method}{Method of selecting SNP locus to retain, 'best' or 'random'
[default 'random'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The genlight object, with the secondary SNP loci removed.
}
\description{
SNP datasets generated by DArT include fragments with more than one SNP and
record them separately with the same CloneID (=AlleleID). These multiple SNP
loci within a fragment (secondaries) are likely to be linked, and so you may
wish to remove secondaries.
This script filters out all but the first sequence tag with the same CloneID
after ordering the genlight object on based on repeatability, avgPIC in that
order (method='best') or at random (method='random').
The filter has not been implemented for tag presence/absence data.
}
\examples{
gl.report.secondaries(testset.gl)
result <- gl.filter.secondaries(testset.gl)
}
\seealso{
Other matched filter: 
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.hamming}()},
\code{\link{gl.filter.ld}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.pa}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched filter}
