% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.callrate.r
\name{gl.report.callrate}
\alias{gl.report.callrate}
\title{Reports summary of Call Rate for loci or individuals}
\usage{
gl.report.callrate(
  x,
  method = "loc",
  ind.to.list = 20,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.dir = NULL,
  plot.file = NULL,
  bins = 50,
  verbose = NULL,
  ...
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{method}{Specify the type of report by locus (method='loc') or
individual (method='ind') [default 'loc'].}

\item{ind.to.list}{Number of individuals to list for callrate [default 20]}

\item{plot.display}{Specify if plot is to be displayed in the graphics window [default TRUE].}

\item{plot.theme}{User specified theme [default theme_dartR()].}

\item{plot.colors}{Vector with two color names for the borders and fill
[default c("#2171B5", "#6BAED6")].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{plot.file}{Filename (minus extension) for the RDS plot file [Required for plot save]}

\item{bins}{Number of bins to display in histograms [default 25].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}

\item{...}{Parameters passed to function \link[ggplot2]{ggsave}, 
such as width and height, when the ggplot is to be saved.}
}
\value{
Returns unaltered genlight object
}
\description{
SNP datasets generated by DArT have missing values primarily arising from
failure to call a SNP because of a mutation at one or both of the restriction
enzyme recognition sites. P/A datasets (SilicoDArT) have missing values
because it was not possible to call whether a sequence tag was amplified or
not.
}
\details{
This function expects a genlight object, containing either SNP data or
SilicoDArT (=presence/absence data).

Callrate is summarized by locus or by individual to allow sensible decisions
on thresholds for filtering taking into consideration consequential loss of
data. The summary is in the form of a tabulation and plots.

The table of quantiles is useful for deciding a threshold for subsequent filtering
as it provides an indication of the percentages of loci that will be retained and 
lost. 

To avoid issues from inadvertent use of this function in an assignment statement,
the function returns the genlight object unaltered.

 
 A color vector can be obtained with gl.select.colors() and then passed to the function
 with the plot.colors parameter.
 
If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.

 If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir().
}
\examples{
 \donttest{
# SNP data
  test.gl <- testset.gl[1:20,]
  gl.report.callrate(test.gl)
  gl.report.callrate(test.gl,method='ind')
  gl.report.callrate(test.gl,method='ind',plot.file="test")
  gl.report.callrate(test.gl,method='loc',by.pop=TRUE)
  gl.report.callrate(test.gl,method='loc',by.pop=TRUE,plot.file="test")
# Tag P/A data
  test.gs <- testset.gs[1:20,]
  gl.report.callrate(test.gs)
  gl.report.callrate(test.gs,method='ind')
  }
  test.gl <- testset.gl[1:20,]
  gl.report.callrate(test.gl)
  
}
\seealso{
\code{\link{gl.filter.callrate}}

Other matched report: 
\code{\link{gl.report.allna}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched report}
