% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.random.snp.r, R/gl.randomize.snps.r
\name{gl.randomize.snps}
\alias{gl.randomize.snps}
\title{Randomly changes the allocation of 0's and 2's in a genlight object}
\usage{
gl.randomize.snps(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)

gl.randomize.snps(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report [default NULL,
unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object with half of the loci re-coded.

Returns a genlight object with half of the loci re-coded.
}
\description{
This function samples randomly half of the SNPs and re-codes, in the sampled
SNP's, 0's by 2's.

This function samples randomly half of the SNPs and re-codes, in the sampled
SNP's, 0's by 2's.
}
\details{
DArT calls the most common allele as the reference allele. In a genlight
object, homozygous for the reference allele are coded with a '0' and
homozygous for the alternative allele are coded with a '2'. This causes some
distortions in visuals from time to time.
If plot.display = TRUE, two smear plots (pre-randomisation and
post-randomisation) are presented using a random subset of individuals (10)
and loci (100) to provide an overview of the changes.
Resultant ggplots are saved to the session's temporary directory.

DArT calls the most common allele as the reference allele. In a genlight
object, homozygous for the reference allele are coded with a '0' and
homozygous for the alternative allele are coded with a '2'. This causes some
distortions in visuals from time to time.
If plot.display = TRUE, two smear plots (pre-randomisation and
post-randomisation) are presented using a random subset of individuals (10)
and loci (100) to provide an overview of the changes.
Resultant ggplots are saved to the session's temporary directory.
}
\examples{
require("dartR.data")
res <- gl.randomize.snps(platypus.gl[1:5,1:5],verbose = 5)
gl <- gl.filter.monomorphs(testset.gl)
res <- gl.randomize.snps(gl,verbose = 5)
}
\author{
Custodian: Luis Mijangos -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
