% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_psa_samp.R
\name{gen_psa_samp}
\alias{gen_psa_samp}
\title{Generate PSA Sample}
\usage{
gen_psa_samp(
  params = NULL,
  dists = c("normal", "log-normal", "truncated-normal", "beta", "gamma", "dirichlet",
    "bootstrap", "constant", "triangle"),
  parameterization_types = c("mean, sd", "a, b", "shape, scale",
    "value, mean_prop, sd", "value, n", "value, alpha", "mean, sd, ll, ul", "val",
    "meanlog, sdlog", "ll, ul, mode"),
  dists_params = NULL,
  nsamp = 100
)
}
\arguments{
\item{params}{string vector with the names of parameters to be generated by \code{gen_psa_samp}
and used by a user-defined function in \code{run_psa} to calculate outcomes.}

\item{dists}{string vector with the distributions from which \code{params} will be drawn.}

\item{parameterization_types}{string vector with parameterization types for each \code{dists}}

\item{dists_params}{list of input parameters required to
 by specific \code{dists} and \code{parameterization_types}
to fully describe distribution and generate parameter samples.}

\item{nsamp}{number of sets of parameter values to be generated}
}
\value{
A dataframe with samples of parameters for a probabilistic sensitivity analysis (PSA)
}
\description{
\code{gen_psa_samp} generates a data.frame of sampled parameter values from
user-specified distributions
to be used in a probabilistic sensitivity analysis (PSA)
}
\details{
Length of vectors \code{params}, \code{dists}, \code{parameterization_types}, and list \code{dists_params} must all
be the same.
The nth element of \code{dists}, \code{parameterization_types}, and \code{dists_params}
all define the distribution that will be
used to draw samples of the corresponding nth element of the \code{params} vector.

For a given element of \code{params}:
\itemize{
\item If \code{dists == "normal"}, \code{parameterization_types} can only be \code{"mean, sd"},
and the corresponding element of list \code{dists_params} must be the the vector \code{c(mean, sd)}

\item If \code{dists == "log-normal"}, \code{parameterization_types} can be either \code{"mean, sd"} or
\code{"meanlog, sdlog"}, and the corresponding element of list \code{dists_params} must be either
the the vector \code{c(mean, sd)} or \code{c(meanlog, sdlog)}. Use \code{"mean, sd"} if you have
sample mean and sample standard deviation of an empirical sample of the random variable, and use
\code{"meanlog, sdlog"} if you want to directly specify the parameters of the log-normal distribution
as specified by \code{\link{rlnorm}}

\item If \code{dists == "truncated-normal"}, \code{parameterization_types} can only be \code{"mean, sd, ll, ul"},
and \code{dists_params} must be the vector \code{c(mean, sd, ll, ul)}, where \code{ll} is
the lower limit of the distribution and \code{ul}
is the upper limit of the distribution. If either the lower limit or the upper
limit does not exist, simply specify \code{NA} in
the corresponding position of the dists_params vector.

\item If \code{dists == "beta"}, \code{parameterization_types} can be \code{"mean, sd"} or \code{"a, b"}
and the corresponding element of list \code{dists_params} must be the the vector \code{c(mean, sd)}
or \code{c(a, b)}, respectively.

\item If \code{dists == "gamma"}, \code{parameterization_types} can be \code{"mean, sd"} or \code{"shape, scale"}
and the corresponding element of list \code{dists_params} must be the the vector \code{c(mean, sd)}
or \code{c(shape, scale)}, respectively.

\item If \code{dists == "dirichlet"}, \code{parameterization_types} can be \code{"value, mean_prop, sd"},
\code{"value, n"}, or \code{"value, alpha"}.
\itemize{
\item If \code{parameterization_types == "value, mean_prop, sd"},
then the corresponding element of list \code{dists_params} must be a data.frame where the first column
is a string vector of the the different multinomial outcomes. These multinomial outcomes will become column names
in the data.frame returned by \code{gen_psa_samp}, and therefore the strings in this column should correspond to
variable names used in \code{FUN} for \code{\link{run_psa}}. The second and
third columns of this \code{dists_params}
should be numerical vectors containing the sample means and sample standard errors for
each of the multinomial outcomes.

\item If \code{parameterization_types == "value, n"}, then \code{dists_params} must be a
data.frame with the first column
being a string vector of the multinomial outcomes, and the second column being a
vector of the observed number of each
multinomial outcome in a sample.

\item If \code{parameterization_types == "value, alpha"}, then \code{dists_params} must be a data.frame with
the first column being a string vector of the multinomial outcomes, and
 the second column must be a numerical vector
of the alpha parameter values for each multinomial outcome in the dirichlet distribution.
}

\item If \code{dists == "bootstrap"}, \code{parameterization_types} can only be
 \code{"value, weight"}, and \code{dists_params}
must be a data.frame with the first column being a numerical vector
containing all of the bootstrap sample values, and
the second column being an integer vector designating the
sampling weights of each bootstrap sample value.  For example,
the number of rows in the \code{dists_params} data.frame
is the number of individuals in the population to be sampled
from (with replacement) or the number of values an
empirical distribution (e.g. a histogram). If each individual value in the
sample is unique and should be weighted equally,
set each weight to 1. If the sample distribution resembles a histogram,
the weights should be equal to the number of
observations for each unique value in the empirical distribution.

\item If \code{dists == "constant"}, \code{parameterization_types} can only be \code{"val"},
and \code{dists_params} must be a single numerical value.
}
}
\examples{
#define parameter names
params <- c("normal_param", "lognorm_param", "truncnorm_param", "beta_param",
            "gamma_param", "dirichlet_param", "bootstrap_param")

#indicate parent distribution types for each parameter
dists <- c("normal", "log-normal", "truncated-normal", "beta", "gamma", "dirichlet", "bootstrap")

#indicate which type of parameterization is used for each parent distribution
parameterization_types <- c("mean, sd", "mean, sd", "mean, sd, ll, ul", "mean, sd", "mean, sd",
                          "value, mean_prop, sd", "value, weight")

#provide distribution parameters that fully define each parent distribution, and
#ensure that these distribution parameters match the form expected by each combination of dists
#and parameterization_types
dists_params <- list(c(1, 2), c(1, 3), c(1, 0.1, NA, 1), c(.5, .2), c(100, 1),
                   data.frame(value = c("level1", "level2", "level3"),
                              mean_prop = c(.1, .4, .5), sd = c(.05, .01, .1)),
                   data.frame(value = c(1, 2, 4, 6, 7, 8),
                              weight = c(1, 1, 1, 1, 1, 4)))

#generate 100 samples of parameter values to be used in a probabilistic sensitivity analysis
gen_psa_samp(params = params,
             dists = dists,
             parameterization_types = parameterization_types,
             dists_params = dists_params,
             nsamp = 100)

}
\seealso{
\code{\link{run_psa}}
}
